////////////////////////////////////////////////
//
//     -- Mikael Beckius 2009 --
//
////////////////////////////////////////////////

#include <reent.h>
#include <eikenv.h>
#include <e32cmn.h>
#include <string.h>

#include "fighter512.h"
#include "S60Gles1View.h"

#include <S60Gles1.rsg>

#ifndef GL_BGRA
#define GL_BGRA  0x80E1
#endif

static GLfloat vertices[] ={-40,40, -40,-40, 40,40, 40,-40}; 
static GLfloat texCoords[] = {0.0,1.0, 0.0,0.0, 1.0,1.0, 1.0,0.0};

CTestTimer *CTestTimer::NewL(){
	CTestTimer* timer = new(ELeave)CTestTimer;
	CleanupStack::PushL(timer);
	timer->ConstructL();
	CleanupStack::Pop();
	return timer;
	}

CTestTimer::CTestTimer() : CTimer(CActive::EPriorityIdle){
	CActiveScheduler::Add(this);
}


CTestTimer::~CTestTimer(){

}

void CTestTimer::Start(TTimeIntervalMicroSeconds32 aDelay,TTimeIntervalMicroSeconds32 anInterval,TCallBack aCallBack){
	iInterval=anInterval.Int();
	iCallBack=aCallBack;
	HighRes(aDelay);
}

void CTestTimer::RunL()
{
	HighRes(iInterval);
	iCallBack.CallBack();
}

CCubeView* CCubeView::NewL(const TRect& aRect){
	CCubeView* cmv = new(ELeave)CCubeView;
	CleanupStack::PushL(cmv);
	cmv->ConstructL(aRect);
	CleanupStack::Pop();
	return cmv;
}

CCubeView::~CCubeView(){
	delete iPeriodic;
	delete iBitmap;
	eglMakeCurrent(iDpy,0,0,0);
	eglDestroyContext(iDpy,iCtx);
	eglDestroySurface(iDpy,iDraw);
	eglTerminate(iDpy);
}

void CCubeView::ConstructL(const TRect& aRect){
	RDebug::Printf("CCubeView::ConstructL\n");
	TRAPD(error,CreateWindowL());
	if(error){
		// Something is wrong, but basically I just dislike warnings!
	}

	TRect rect(20,20,220,220);
	SetRect(rect);
	// SetExtentToWholeScreen();

	int minor = 0;
	int major = 0;
	EGLint numConfigs = 0;

	EGLConfig   cfg;

	EGLint attrib[] = {EGL_BUFFER_SIZE, EGL_DONT_CARE,
		EGL_SURFACE_TYPE,EGL_PBUFFER_BIT|EGL_WINDOW_BIT,
		EGL_RED_SIZE,       8,
		EGL_GREEN_SIZE,     8,
		EGL_BLUE_SIZE,      8,
		EGL_ALPHA_SIZE,     8,
		EGL_DEPTH_SIZE,			24,
		EGL_NONE};

	iDpy = eglGetDisplay(EGL_DEFAULT_DISPLAY);

	if(!iDpy){
		RDebug::Printf("Failed to open the EGL default display");
	}

	if(!eglInitialize(iDpy,&major,&minor)){
		RDebug::Printf("Failed to init the EGL default display");
	}

	if(!eglChooseConfig(iDpy,attrib,&cfg,1,&numConfigs)||(numConfigs<1)){
		RDebug::Printf("Failed to find a config on the EGL default display");
	}

	iCtx = eglCreateContext(iDpy,cfg,EGL_NO_CONTEXT,0);
	if(!iCtx){
		RDebug::Printf("Failed to create a context");
	}

	// iDraw = eglCreateWindowSurface(iDpy,cfg,DrawableWindow(),0);
	iDraw = eglCreateWindowSurface(iDpy,cfg,&Window(),0);
	if(!iDraw){
		RDebug::Printf("Failed to create a context");
	}

	if(!eglMakeCurrent(iDpy,iDraw,iDraw,iCtx)){
		RDebug::Printf("Failed to make the context current");
	}

  glShadeModel(GL_SMOOTH);

  glEnableClientState(GL_VERTEX_ARRAY);
  glEnableClientState(GL_TEXTURE_COORD_ARRAY);

  glVertexPointer(2,GL_FLOAT,0,vertices);
	glTexCoordPointer(2,GL_FLOAT,0,texCoords);
  
  glColor4f(1.0f,1.0f,1.0f,1.0f);
	glClearColor(0.0,0.0,0.0,0.0);

	unsigned int id;
	glGenTextures(1,&id);
	glBindTexture(GL_TEXTURE_2D,id);
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_BGRA, 512, 512, 0, GL_BGRA, GL_UNSIGNED_BYTE, imageFighterRGBA512);

	glEnable(GL_TEXTURE_2D);

	GLenum e;
	do{
		e=glGetError();
		RDebug::Printf("main glGetError %u",e);
	}while(e!=GL_NO_ERROR);

	ActivateL();

	iRender = true;
	iPeriodic = CTestTimer::NewL();
	iPeriodic->Start(0,10,TCallBack(CCubeView::DrawCallback,this));
}

void CCubeView::draw(){
	int width=Rect().Width();
	int height=Rect().Height();

	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glViewport(0,0,width,height);
  glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrthof(-width/10,width/10,-height/10,height/10,-100.0,100.0);
	glDrawArrays(GL_TRIANGLE_STRIP,0,4);

	eglSwapInterval(iDpy,0);
	eglSwapBuffers(iDpy,iDraw);
}

TInt CCubeView::DrawCallback(TAny* aInstance){
	CCubeView* instance = (CCubeView*)aInstance;
	instance->draw();

	if(!(instance->iFrame%400)){
		User::ResetInactivityTime();
		TBuf<32> buf;
		instance->iEndTime.UniversalTime();
		buf.Format(_L("%f Hz"),400000000.0/(float)(instance->iEndTime.Int64()-instance->iBeginTime.Int64()));
		RDebug::Printf("Frame time: %f",400000000.0/(float)(instance->iEndTime.Int64()-instance->iBeginTime.Int64()));
		User::InfoPrint(buf);			
		instance->iBeginTime.UniversalTime();
	}
	instance->iFrame++;
	return 0;
}

void CCubeView::Draw(const TRect& aRect) const{
	RDebug::Printf("CRCTestView::Draw\n");
	/*
	TRgb color(0,128);
	CWindowGc& gc = SystemGc();
	gc.DrawRect(aRect);
	*/
}

TKeyResponse CCubeView::OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType){
	TBuf<32> buf;

	if(aType == EEventKeyDown) {
		RDebug::Printf("Key code: %d",aKeyEvent.iScanCode);
		switch(aKeyEvent.iScanCode){
								case '0':
								case '1':
								case '2':
								case '3':
								case '4':
									SetRect(TRect(20,20,220,220));
									return EKeyWasConsumed;
								case '5':
									iTestCase=aKeyEvent.iScanCode-'0';
									return EKeyWasConsumed;
								case '6':
									iRender=iRender?false:true;
									return EKeyWasConsumed;
								case 'R':
									return EKeyWasConsumed;
								case 'S':
									SetExtentToWholeScreen();
									return EKeyWasConsumed;
								case 'T':
								case '7':
									SetExtentToWholeScreen();
									return EKeyWasConsumed;
								case 'Q':
								case 167:
								case 172:
								case 212:
								case 213:
								case '8':
									CBaActiveScheduler::Exit();
		}
	}
	return EKeyWasNotConsumed;
}

void CCubeView::HandlePointerEventL(const TPointerEvent& aPointerEvent){
	if(aPointerEvent.iType == TPointerEvent::EButton1Down)
	{
		CBaActiveScheduler::Exit();
	}
}


void CCubeAppUi::ConstructL(){

	BaseConstructL();
	iView=CCubeView::NewL(ClientRect());
	AddToStackL(iView);
}


CCubeAppUi::~CCubeAppUi(){
	RemoveFromStack(iView);
	delete iView;
}

void CCubeAppUi::HandleCommandL(TInt aCommand){
	switch (aCommand){
		// case EEikCmdGoBack:
		//	 CEikAppUi::Exit();
		//	 break;
	case EEikCmdExit: 
		CEikAppUi::Exit();
		break;
	default:
		break;
	}
}

void CCubeAppUi::HandleWsEventL(const TWsEvent& aEvent,CCoeControl* aDestination){
	RDebug::Printf("TWsEvent %d",aEvent.Type());
	switch (aEvent.Type())
	{
	case EEventFocusLost:
		// iView->Stop();
		break;
	case EEventFocusGained:
		// iView->Start();
		break;
	default:
		break;
	}
	CAknAppUi::HandleWsEventL(aEvent, aDestination);
}

CCubeDocument::CCubeDocument(CEikApplication& aApp) : CAknDocument(aApp){

}

CCubeDocument::~CCubeDocument(){

}

CCubeDocument* CCubeDocument::NewL(CEikApplication& aApp){
	CCubeDocument* self=new(ELeave) CCubeDocument(aApp);
	return self;
}

CAknAppUi* CCubeDocument::CreateAppUiL(){
	return(new(ELeave) CCubeAppUi);
}

TUid CCubeApplication::AppDllUid() const{
	return(KUidCube);
}

CApaDocument* CCubeApplication::CreateDocumentL(){
	return CCubeDocument::NewL(*this);
}
